/*
 * Svix API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.1.1
 * Generated by: https://github.com/openapitools/openapi-generator.git
 * 
 * Manually modified to add `EmitDefaultValue = false` in all properties. Null fields are ignored for PATCH requests.
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using FileParameter = Svix.Client.FileParameter;
using OpenAPIDateConverter = Svix.Client.OpenAPIDateConverter;

namespace Svix.Model
{
    /// <summary>
    /// EndpointPatch
    /// </summary>
    [DataContract(Name = "EndpointPatch")]
    public partial class EndpointPatch : IEquatable<EndpointPatch>, IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="EndpointPatch" /> class.
        /// </summary>
        /// <param name="channels">channels.</param>
        /// <param name="description">description.</param>
        /// <param name="disabled">disabled.</param>
        /// <param name="filterTypes">filterTypes.</param>
        /// <param name="metadata">metadata.</param>
        /// <param name="rateLimit">rateLimit.</param>
        /// <param name="secret">The endpoint&#39;s verification secret. If &#x60;null&#x60; is passed, a secret is automatically generated. Format: &#x60;base64&#x60; encoded random bytes optionally prefixed with &#x60;whsec_&#x60;. Recommended size: 24..</param>
        /// <param name="uid">The ep&#39;s UID.</param>
        /// <param name="url">url.</param>
        /// <param name="version">version.</param>
        public EndpointPatch(List<string> channels = default(List<string>), string description = default(string), bool disabled = default(bool), List<string> filterTypes = default(List<string>), Dictionary<string, string> metadata = default(Dictionary<string, string>), int? rateLimit = default(int?), string secret = default(string), string uid = default(string), string url = default(string), int version = default(int))
        {
            this.Channels = channels;
            this.Description = description;
            this.Disabled = disabled;
            this.FilterTypes = filterTypes;
            this.Metadata = metadata;
            this.RateLimit = rateLimit;
            this.Secret = secret;
            this.Uid = uid;
            this.Url = url;
            this.Version = version;
        }

        /// <summary>
        /// Gets or Sets Channels
        /// </summary>
        [DataMember(Name = "channels", EmitDefaultValue = false)]
        public List<string> Channels { get; set; }

        /// <summary>
        /// Gets or Sets Description
        /// </summary>
        [DataMember(Name = "description", EmitDefaultValue = false)]
        public string Description { get; set; }

        /// <summary>
        /// Gets or Sets Disabled
        /// </summary>
        [DataMember(Name = "disabled", EmitDefaultValue = false)]
        public bool Disabled { get; set; }

        /// <summary>
        /// Gets or Sets FilterTypes
        /// </summary>
        [DataMember(Name = "filterTypes", EmitDefaultValue = false)]
        public List<string> FilterTypes { get; set; }

        /// <summary>
        /// Gets or Sets Metadata
        /// </summary>
        [DataMember(Name = "metadata", EmitDefaultValue = false)]
        public Dictionary<string, string> Metadata { get; set; }

        /// <summary>
        /// Gets or Sets RateLimit
        /// </summary>
        [DataMember(Name = "rateLimit", EmitDefaultValue = false)]
        public int? RateLimit { get; set; }

        /// <summary>
        /// The endpoint&#39;s verification secret. If &#x60;null&#x60; is passed, a secret is automatically generated. Format: &#x60;base64&#x60; encoded random bytes optionally prefixed with &#x60;whsec_&#x60;. Recommended size: 24.
        /// </summary>
        /// <value>The endpoint&#39;s verification secret. If &#x60;null&#x60; is passed, a secret is automatically generated. Format: &#x60;base64&#x60; encoded random bytes optionally prefixed with &#x60;whsec_&#x60;. Recommended size: 24.</value>
        [DataMember(Name = "secret", EmitDefaultValue = false)]
        public string Secret { get; set; }

        /// <summary>
        /// The ep&#39;s UID
        /// </summary>
        /// <value>The ep&#39;s UID</value>
        [DataMember(Name = "uid", EmitDefaultValue = false)]
        public string Uid { get; set; }

        /// <summary>
        /// Gets or Sets Url
        /// </summary>
        [DataMember(Name = "url", EmitDefaultValue = false)]
        public string Url { get; set; }

        /// <summary>
        /// Gets or Sets Version
        /// </summary>
        [DataMember(Name = "version", EmitDefaultValue = false)]
        public int Version { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class EndpointPatch {\n");
            sb.Append("  Channels: ").Append(Channels).Append("\n");
            sb.Append("  Description: ").Append(Description).Append("\n");
            sb.Append("  Disabled: ").Append(Disabled).Append("\n");
            sb.Append("  FilterTypes: ").Append(FilterTypes).Append("\n");
            sb.Append("  Metadata: ").Append(Metadata).Append("\n");
            sb.Append("  RateLimit: ").Append(RateLimit).Append("\n");
            sb.Append("  Secret: ").Append(Secret).Append("\n");
            sb.Append("  Uid: ").Append(Uid).Append("\n");
            sb.Append("  Url: ").Append(Url).Append("\n");
            sb.Append("  Version: ").Append(Version).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="input">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object input)
        {
            return this.Equals(input as EndpointPatch);
        }

        /// <summary>
        /// Returns true if EndpointPatch instances are equal
        /// </summary>
        /// <param name="input">Instance of EndpointPatch to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(EndpointPatch input)
        {
            if (input == null)
                return false;

            return
                (
                    this.Channels == input.Channels ||
                    this.Channels != null &&
                    input.Channels != null &&
                    this.Channels.SequenceEqual(input.Channels)
                ) &&
                (
                    this.Description == input.Description ||
                    (this.Description != null &&
                    this.Description.Equals(input.Description))
                ) &&
                (
                    this.Disabled == input.Disabled ||
                    this.Disabled.Equals(input.Disabled)
                ) &&
                (
                    this.FilterTypes == input.FilterTypes ||
                    this.FilterTypes != null &&
                    input.FilterTypes != null &&
                    this.FilterTypes.SequenceEqual(input.FilterTypes)
                ) &&
                (
                    this.Metadata == input.Metadata ||
                    this.Metadata != null &&
                    input.Metadata != null &&
                    this.Metadata.SequenceEqual(input.Metadata)
                ) &&
                (
                    this.RateLimit == input.RateLimit ||
                    (this.RateLimit != null &&
                    this.RateLimit.Equals(input.RateLimit))
                ) &&
                (
                    this.Secret == input.Secret ||
                    (this.Secret != null &&
                    this.Secret.Equals(input.Secret))
                ) &&
                (
                    this.Uid == input.Uid ||
                    (this.Uid != null &&
                    this.Uid.Equals(input.Uid))
                ) &&
                (
                    this.Url == input.Url ||
                    (this.Url != null &&
                    this.Url.Equals(input.Url))
                ) &&
                (
                    this.Version == input.Version ||
                    this.Version.Equals(input.Version)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            unchecked // Overflow is fine, just wrap
            {
                int hashCode = 41;
                if (this.Channels != null)
                    hashCode = hashCode * 59 + this.Channels.GetHashCode();
                if (this.Description != null)
                    hashCode = hashCode * 59 + this.Description.GetHashCode();
                hashCode = hashCode * 59 + this.Disabled.GetHashCode();
                if (this.FilterTypes != null)
                    hashCode = hashCode * 59 + this.FilterTypes.GetHashCode();
                if (this.Metadata != null)
                    hashCode = hashCode * 59 + this.Metadata.GetHashCode();
                if (this.RateLimit != null)
                    hashCode = hashCode * 59 + this.RateLimit.GetHashCode();
                if (this.Secret != null)
                    hashCode = hashCode * 59 + this.Secret.GetHashCode();
                if (this.Uid != null)
                    hashCode = hashCode * 59 + this.Uid.GetHashCode();
                if (this.Url != null)
                    hashCode = hashCode * 59 + this.Url.GetHashCode();
                hashCode = hashCode * 59 + this.Version.GetHashCode();
                return hashCode;
            }
        }

        /// <summary>
        /// To validate all properties of the instance
        /// </summary>
        /// <param name="validationContext">Validation context</param>
        /// <returns>Validation Result</returns>
        IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
        {
            // RateLimit (int?) minimum
            if (this.RateLimit < (int?)0)
            {
                yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for RateLimit, must be a value greater than or equal to 0.", new[] { "RateLimit" });
            }

            // Secret (string) pattern
            Regex regexSecret = new Regex(@"^(whsec_)?[a-zA-Z0-9+\/=]{32,100}$", RegexOptions.CultureInvariant);
            if (false == regexSecret.Match(this.Secret).Success)
            {
                yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Secret, must match a pattern of " + regexSecret, new[] { "Secret" });
            }

            // Uid (string) maxLength
            if (this.Uid != null && this.Uid.Length > 256)
            {
                yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Uid, length must be less than 256.", new[] { "Uid" });
            }

            // Uid (string) minLength
            if (this.Uid != null && this.Uid.Length < 1)
            {
                yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Uid, length must be greater than 1.", new[] { "Uid" });
            }

            // Uid (string) pattern
            Regex regexUid = new Regex(@"^[a-zA-Z0-9\\-_.]+$", RegexOptions.CultureInvariant);
            if (false == regexUid.Match(this.Uid).Success)
            {
                yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Uid, must match a pattern of " + regexUid, new[] { "Uid" });
            }

            // Version (int) minimum
            if (this.Version < (int)1)
            {
                yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Version, must be a value greater than or equal to 1.", new[] { "Version" });
            }

            yield break;
        }
    }

}
